﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IMMeDotNet {

	/// <summary>
	/// Represents a target for a <see cref="UsbMessage"/>.
	/// </summary>
	class MessageTarget {

		/// <summary>
		/// The ID of the message.
		/// </summary>
		public byte MessageID { get; set; }

		/// <summary>
		/// The ID of the connection.
		/// </summary>
		public byte ConnectionID { get; set; }

		/// <summary>
		/// The ID of the contact.
		/// </summary>
		public uint ContactID { get; set; }

		/// <summary>
		/// Creates an instance of a <see cref="MessageTarget"/>.
		/// </summary>
		public MessageTarget(byte messageID, byte connectionID, uint contactID) {
			this.MessageID = messageID;
			this.ConnectionID = connectionID;
			this.ContactID = contactID;
		}
	}

	class IdentifiedMessageTarget : MessageTarget {

		/// <summary>
		/// The targeted connection.
		/// </summary>
		public Connection Connection { get; set; }

		/// <summary>
		/// The targeted contact.
		/// </summary>
		public Contact Contact { get; set; }

		public IdentifiedMessageTarget(byte messageID, byte connectionID, uint contactID)
			: base(messageID, connectionID, contactID) {
		}

	}
}
